/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.message;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import svenhjol.charm.base.iface.ICharmMessage;
import svenhjol.charm.module.InventoryTidying;

public class ServerSortInventory
implements ICharmMessage {
    public static final int PLAYER = 0;
    public static final int TILE = 1;
    private final int type;

    public ServerSortInventory(int type) {
        this.type = type;
    }

    public static void encode(ServerSortInventory msg, PacketBuffer buf) {
        buf.writeInt(msg.type);
    }

    public static ServerSortInventory decode(PacketBuffer buf) {
        return new ServerSortInventory(buf.readInt());
    }

    public static class Handler {
        public static void handle(ServerSortInventory msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
                ServerPlayerEntity player = context.getSender();
                if (player == null) {
                    return;
                }
                InventoryTidying.serverCallback(player, msg.type);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

